#include "EasyPOD.H"
#include "TWSI.H"


//----- TWSI -----//
extern BYTE OutLen;
extern BYTE OutBuffer[TWSI_MAX];
extern void Initial_TWSI( void );
extern void TWSI_Send_Data_To_Device( void );
extern void TWSI_Send_Data_To_PC( void );

void USB_Event( void );


void main( void )
  { Initial();                                   // Do not remove
    
    Initial_TWSI();
    
    while(1)
      { if ( InFlag )                            // Data size of "InLen" is already 
          { // To do..                           // in the "InBuffer[]"
            TWSI_Send_Data_To_Device();          // InLen and InBuffer content will be
            if ( InLen )                         // change in this function
              USB_Send_Data_To_PC( InLen , InBuffer );
            USB_Read_Data_Complete();            // Do not remove
          }
        
        TWSI_Send_Data_To_PC();
        
        USB_Event();                             // Check USB power event
      }   
  }


void USB_Event( void )                           // Do not remove
  { if ( UsbEvent.Suspend == SET )               // Power down event from HOST
      { UsbEvent.Suspend = CLR;
        // To do..
        PCON |= 0x02;                            // MCU will into PowerDown mode
        UsbEvent.WakeUp = SET;
      }
    if ( UsbEvent.WakeUp == SET )                // MCU wakeup already
      { UsbEvent.WakeUp = CLR;
      	// To do..
      }
    if ( UsbEvent.Reset == SET )                 // Reset event from HOST
      { UsbEvent.Reset = CLR;
        // To do..
      }
    if ( UsbEvent.EmuOK == SET )                 // USB enumeration OK
      { // To do..
      }
  }